%Descripcin: rotorind.m
%
%	Programa que resuelve el conjunto de ecuaciones diferenciales que 
%  describen el comportamiento dinmico del Rotor del Motor de Induccin:
%            - Ecuaciones para establecer la interfase del rotor con la red esttica
%            - Ecuacin de oscilacin del rotor
%
%Funcin que emplea: Cinic.m
%
%	Este bloque S-function acta como una subrutina ejecutada en Matlab.
%
%  Se evalua la salida como:
%  y = f(u)
%  u : entradas
%  y : Salidas   son  devueltas en sys
%
%
%	Parmetros de entrada:
%                      - Variables de estado x
%                      - Variables de entrada u
%                      - Parmetros del motor: Rs, Xs, Xm, Xr, Rr, H
%                      - Constantes del par mecnico: A*w^2+B*w+C
%                      - Potencia activa y tensin del motor: Pm, Um
%
%	Variables de salida:
%                      - sys: Tensin aplicada al rotor u'd+ju'q y velocidad wr
%
%ECUACIONES DIFERENCIALES DEL ROTOR DE INDUCCIN

function [sys, x0]=rotorind(t,x,u,flag,Rs,Xs,Rr,Xr,Xm,H,A,B,C,D,Pm,Um)

%Parametros

Wb=2*pi*60; 
X  = (Xs + Xm);
Xp = ( Xs + Xm*Xr/(Xm+Xr) );

%Clculo de la condiciones iniciales del motor conocida la potencia activa y tensin

[Te,dato]=Cinic(Pm,Um,Rs,Xs,Xm,Xr,Rr); 

wo=dato(3);               % Velocidad inicial del rotor en p.u.

To = Te/(A*wo^2+B*wo+C);  % Constante del par mecnico inicial en p.u.
Top = ((Xr+Xm)/Rr)/Wb;    % Constante de tiempo del rotor en seg.  

%Nomenclatura utilizada:

%Variables de estado
%x(1) = u'd  Parte real de la tensin aplicada al rotor en p.u. 
%x(2) = u'q  Parte imaginaria de la tensin aplicada al rotor en p.u.
%x(3) = wr   Velocidad del rotor en p.u.

%Variables de entrada:
%u(1) = ids  Parte real de la intensidad absorbida por el motor
%u(2) = iqs  Parte imaginaria de la intensidad absorbida por el motor

%Modelo

if abs(flag)==1
   
   %Variables de estado del sistema
   sys(1) = -1/Top*(x(1)+(X-Xp)*u(2)) + (1-x(3))*Wb*x(2); 
   sys(2) = -1/Top*(x(2)-(X-Xp)*u(1)) - (1-x(3))*Wb*x(1);
   sys(3) =  1/(2*H)*(x(1)*u(1) + x(2)*u(2) - To*(A*x(3)^2 + B*x(3) +C) - D*x(3));
   
elseif flag==3
   
      %Salida del sistema
      sys=[x(1); x(2);x(3)];
      
   elseif flag==0
      
        %Parmetros y condiciones iniciales  
         %1ro: Nmero de estados continuos
         %2do: Nmero estados discretos
         %3ro: Nmero de salidas  x
         %4to: Nmero de entradas u
         
         sys=[3;0;3;2;0;0];
         x0=dato;       
         
      else
         
         sys=[];
 end
