%Descripcin: Tfdq.m
%
%	Bloque para transformar tensiones en ejes real-imaginario a tensiones en ejes d-q 
%  en el generador sncrono.
%
%	Este bloque S-function actua como una subrutina ejecutada en Matlab.
%  no existen variables continuas (derivadas)
%
%  Se evalua la salida como:
%  y = f(u)
%  u : entradas
%  y : Salidas   son  devueltas en sys
%
%
%	Parmetros de entrada:
%                      - Variables de entrada u
%                     
%	Variables de salida:
%                      - sys: tensiones referidas a los ejes d-q
%

function [sys, x0 ]=Tfdq(t,x,u,flag)

%Nomenclatura utilizada:
%Variables de Salida
%sys(1) = u'd     Tensin referida al eje d
%sys(2) = u'q     Tensin referida al eje q

%Variables de entrada:
%u(1) = ureal     Tensin referida al eje real
%u(2) = uimag     Tensin referida al eje imaginario
%u(3) = delta     ngulo entre el eje q y el eje real
 
if flag==3
      
   %salida del sistema
   A=[sin(u(3)) cos(u(3)); - cos(u(3)) sin(u(3))];
   Udq=inv(A)*[u(1); u(2)];
   sys =[Udq(1) ; Udq(2)];

   elseif flag==0
      
         %Parmetros y condiciones iniciales
         %1ro: Nmero de estados continuos
         %2do: Nmero estados discretos
         %3ro: Nmero de salidas  x
         %4to: Nmero de entradas u
         % los otros cero
         
         sys=[0;0;2;3;0;1];
         x0=[];     
         
      else
         
         sys=[];
 end
