%Descripcin: Tdqf.m
%
%	Bloque para transformar intensidades d-q a intensidades en ejes real-imaginario
%
%	Este bloque S-function actua como una subrutina ejecutada en Matlab.
%  no existen variables continuas (derivadas)
%
%  Se evalua la salida como:
%  y = f(u)
%  u : entradas
%  y : Salidas   son  devueltas en sys
%
%
%	Parmetros de entrada:
%                      - Variables de entrada u
%                     
%	Variables de salida:
%                      - sys: intensidades referidas a los ejes real-imaginario
%


function [sys, x0 ]=Tdqf(t,x,u,flag)

%Nomenclatura utilizada:

%Variables de Salida
%sys(1) = Ireal    Intensidad referida al eje real
%sys(2) = Iimag    Intensidad referida al eje imaginario

%Variables de entrada:
%u(1) = i'd        Intensidad referida al eje d
%u(2) = i'q        Intensidad referida al eje q
%u(3) = delta      ngulo entre el eje q y el eje real

   
   if flag==3
      
   %salida del sistema
   A=[sin(u(3)) cos(u(3)); - cos(u(3)) sin(u(3))];
   Irm=A*[u(1); u(2)];
   sys =[Irm(1) ; Irm(2)];

elseif flag==0
   
         %Parmetros y condiciones iniciales
         %1ro: Nmero de estados continuos
         %2do: Nmero estados discretos
         %3ro: Nmero de salidas  x
         %4to: Nmero de entradas u
         % los otros cero
         
         sys=[0;0;2;3;0;1];
         x0=[];     
         
      else
         
         sys=[];
         
 end
