%Descripcin: gsinc.m
%
%  Programa que resuelve el conjunto de ecuaciones que permiten simular  
%  la dinmica del estator del compensador sncrono
%
%	Se llama como bloque S-function y acta como una subrutina ejecutada en Matlab.
%
%  Se evalua la salida como:
%  y = f(u)
%  u : entradas
%  y : Salidas   son  devueltas en sys
%
%  %
%	Parmetros de entrada:
%                      - Variables de entrada u
%                      - Parmetros del generador: Ra,Xd,Xq,Xdp
%                      - Reactancia del transformador de acoplamiento:  Xt
%
%	Variables de salida:
%                      - sys: Intensidades i'd+ji'q y velocidad wr
%
%ECUACIONES DEL COMPENSADOR SNCRONO
function [sys, x0 ]=gsinc(t,x,u,flag,Ra,Xd,Xq,Xdp,Xt)

%Nomenclatura utilizada:
Xd=Xd+Xt;           %Suma Xtrafo a cada X del generador
Xq=Xq+Xt;
Xdp=Xdp+Xt;

%Variables de Salida
%sys(1) = i'd       Intensidad en el eje d cedida  por el compensador
%sys(2) = i'q       Intensidad en el ej q cedida por el compensador
%sys(3) = El        Tensin El proporcional a la excitacin

%Variables de entrada:
%u(1) = u'd         Tensin en el eje d aplicada al rotor del compensador
%u(2) = u'q         Tensin en el eje q aplicada al rotor del compensador
%u(3) = E'q         Tensin E'q del modelo del Compensador 

if flag==3
      
   %salida del sistema
   A=[-Ra Xq ; -Xdp -Ra];
   udq=[u(1) u(2)]';
   B=[0 u(3)]';
   Idq=inv(A)*(udq-B);         % Intensidades d-q cedidas por el compensador=[i'd;i'q]
   El=u(3)+(Xd-Xdp)*Idq(1);
   sys =[Idq(1) Idq(2) El];

elseif flag==0
   
         %Parmetros y condiciones iniciales
         %1ro: Nmero de estados continuos
         %2do: Nmero estados discretos
         %3ro: Nmero de salidas  x
         %4to: Nmero de entradas u
         % los otros cero
         
         sys=[0;0;3;3;0;1];
         x0=[];        
         
      else
         
         sys=[];
 end
