%Descripcin: geosc.m
%
%	Programa que resuelve la ecuacin diferencial que 
%  describe la oscilacin del rotor del compensador sncrono
%
%	Se llama como bloque S-function y acta como una subrutina ejecutada en Matlab
%  
%  Se evalua la salida como:
%  y = f(u)
%  u : entradas
%  y : Salidas   son  devueltas en sys
%
%
%	Parmetros de entrada:
%                      - Variables de estado x
%                      - Variables de entrada u
%                      - Parmetros del motor:H
%                     
%	Variables de salida:
%                      - sys: ngulo delta y variacin de velocidad del rotor wr
%
%ECUACIN DIFERENCIAL DEL ROTOR DEL COMPENSADOR SNCRONO

function [sys, x0]=geosc(t,x,u,flag,H)

%Variables de estado
%x(1) = delta (ngulo entre el eje q y el eje real)
%x(2) = Incremento de velocidad del rotor wr

%Variables de entrada:
%u(1) = i'd     Intensidad en eje d cedida por el compensador 
%u(2) = i'q     Intensidad en eje q cedida por el compensador 
%u(3) = u'd     Tensin en el eje d aplicada al rotor
%u(4) = u'q     Tensin en el eje q aplicada al rotor

%ECUACIN DE OSCILACIN DEL COMPENSADOR SNCRONO
if abs(flag)==1
   
   %variables de estado del sistema
   sys(1) = x(2)*2*pi*60;    %Debe multiplicarse por Wb porque delta est en radianes
   sys(2) = -1/(2*H)*(u(1)*u(3) + u(2)*u(4));
   
elseif flag==3
   
      %salida del sistema
      sys=[x(1); x(2)];
      
   elseif flag==0
      
         %Parmetros y condiciones iniciales  
         %1ro: Nmero de estados continuos
         %2do: Nmero estados discretos
         %3ro: Nmero de salidas  x
         %4to: Nmero de entradas u
         
         sys=[2;0;2;4;0;0];
         delta_inicial= 5.6726*pi/180;  % ngulo tensin nudo del compensador 
                                        % en rg. permanente
         wr_inicial=0;                  % Variacin inicial de la velocidad wr   
         x0=[delta_inicial ; wr_inicial];        
        
      else
         
         sys=[];
 end
