%Descripcin: cinic.m
%
%	Funcin que emplea el circuito equivalente para rgimen estacionario
%  del motor de induccin para calcular las condiones en rgimen permanente
%  de las variables:
%                      - Deslizamiento
%                      - Velocidad del rotor
%                      - Intensidad absorbida por motor
%                      - Tensin aplicada al rotor
%                      - Potencia reactiva
%                      - Par elctrico
%	Datos de entrada:
%                      - Tensin del motor Um
%                      - Potencia activa absorbida Pm
%                      - Parmetros del motor: Rs,Xs,Xm,Xr,Rr
%	Variables de salida:
%                      - Par elctrico Te
%                      - Vector x0=[Parte real tensin aplicada al rotor u'd
%                                   Parte imaginaria tensin aplicada al rotor u'q
%                                   Velocidad del rotor wr]


function [Te,x0]=cinic(Pm,Um,Rs,Xs,Xm,Xr,Rr)

% Resolucin de la ecuacin de segundo grado para el clculo del deslizamiento

Xp=Xs+Xm*Xr/(Xm+Xr);
A=-Xs*(Xm+Xr)-Xr*Xm;
B=Rs*(Xm+Xr);
C=Pm*A^2+Pm*B^2-Rs*(Xm+Xr)^2;
D=2*Pm*Rs*Rr*A+2*Pm*(Xs*Rr+Rr*Xm)*B-Rr*Xm^2;
E=Pm*(Rs*Rr)^2+Pm*(Xs*Rr+Rr*Xm)^2-Rs*Rr^2;
sol=roots([C D E]);

s=min(sol);                         % Deslizamiento 
x0(3)=1-s;                          % Wr inicial en p.u.

% Fasor intensidad absorbida en p.u.

Im=Um/(Rs+j*Xs+(Rr/s+j*Xr)*j*Xm/(Rr/s+j*(Xm+Xr))); 


Up=Um-(Rs + j*Xp)*Im;

x0(1)=real(Up);                    % U'd inicial en pu.
x0(2)=imag(Up);                    % U'q inicial en pu.

Qm=imag(Um*conj(Im));              % Potencia reactiva
Te=x0(1)*real(Im)+x0(2)*imag(Im);  % Par elctrico


